package w83b.w83bOperacionesPaso.w83bCitaciones;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bComunicacionCitacionAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		HashMap plantillas=(HashMap)contexto.get("w83bPlantillasMap");
		W83bPlantillasBean plantilla=(W83bPlantillasBean)plantillas.get(W83bClsConstantes.NOTIFICACION_CITACION.toUpperCase());
		W83bClsTrazas.trazaError(null, "plantillas "+plantilla, null);
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
	    
		HashMap datos=(HashMap)contexto.get("w83bMapResultadosBean");
		String[] resul = (String[])datos.get("numRegistro");
		W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	    StringBuffer  tituloDelelegacionEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
		StringBuffer  tituloDelelegacionEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
		StringBuffer  tituloDepEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloDepEs = (StringBuffer)datosDelDep.get("tituloDepEs");
		W83bCitacionBean citacion=(W83bCitacionBean)contexto.get("w83bCitacionDetalleBean");
		StringBuffer buffer=new StringBuffer();
		HashMap mapaPar = new HashMap();
		String aux="";
		//String aux=citacion.getTerritorioImpugnacion()+"/"+citacion.getAnyoImpugnacion()+"/"+citacion.getNumImpugnacion();
		if (citacion.getNacta().charAt(0)=='a'){
			mapaPar.put("<<EXPDTE>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",idioma)+": "+citacion.getNacta().substring(1,citacion.getNacta().length()));
		}
		else{
			mapaPar.put("<<EXPDTE>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",idioma)+": "+citacion.getNacta().substring(1,citacion.getNacta().length()));
		}
		mapaPar.put("<<DEPEUS>>",tituloDepEu.toString());
		mapaPar.put("<<DEPCAS>>",tituloDepEs.toString());
		mapaPar.put("<<DELEUS>>",tituloDelelegacionEu.toString());
		mapaPar.put("<<DELCAS>>",tituloDelelegacionEs.toString());
		aux=citacion.getFechaImpugnacion();
		if(aux==null)
		{
			aux="";
		}
		mapaPar.put("<<FIMPUG>>",aux);
		aux=citacion.getFechaCitacion();
		if(aux==null)
		{
			aux="";
		}
		mapaPar.put("<<FCITAC>>",aux);
		aux=citacion.getHoraCitacionInicio();
		if(aux==null)
		{
			aux="";
		}
		mapaPar.put("<<HORA>>",aux);
		
		mapaPar.put("<<DESCLUGAR>>",tituloDelelegacionEs.toString());
		
		mapaPar.put("<<DIR>>",W83bUtilidadesComunes.obtenerCalledelegacionFormateada(usuario).toString());
		String codigopostal="";
		if(StringUtils.isNotEmpty(usuario.getCodigoPostalDelegacion())){
			codigopostal=usuario.getCodigoPostalDelegacion();
		}
		mapaPar.put("<<CPOST>>",codigopostal);
		
		mapaPar.put("<<MUNIC>>",usuario.getLocalidadTxtCastDelegacion());
		
		SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
		
		String fecha = hoy.format(new Date());
		String numSalida = resul[0];
		
//		mapaPar.put("<<FECHA>>",hoy.format(new Date()));
		
		List fa;
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			fa=W83bDateUtil.getInstance().separarDiaMesAnyo(fecha,W83bClsConstantes.CONSTANTE_CASTELLANO);
		}
		else{
			fa=W83bDateUtil.getInstance().separarDiaMesAnyo(fecha,W83bClsConstantes.CONSTANTE_EUSKARA);
		}
		mapaPar.put("<<FECHA>>",W83bDateUtil.getInstance().devolverLiteralfechamin(Integer.parseInt((String)fa.get(0)),Integer.parseInt((String)fa.get(1)),Integer.parseInt((String)fa.get(2)),idioma).toString());
		mapaPar.put("<<NUMSALIDA>>",numSalida);
		mapaPar.put("<<DELEGADO>>",datos.get("nombreFirmante"));
		String cargo=W83bClsConstantes.VACIO;
		String descFirmante=W83bClsConstantes.VACIO;
		if(W83bClsConstantes.CONSTANTE_EUSKARA.equals(contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)))
				{
			 		cargo=(String)datos.get("cargoFirmanteEusk");
			 		descFirmante=tituloDelelegacionEu.toString().concat("ko ").concat(cargo);
				}else{
					cargo=(String)datos.get("cargoFirmanteCast");
					descFirmante=cargo.concat(" de la ").concat(tituloDelelegacionEs.toString());
				}
		
	   
			
		mapaPar.put("<<LINEARESPONSABLE>>",descFirmante);
		StringBuffer aldeak=new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
   		aldeak.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.aldeakMulti",idioma)).append(":");
   		aldeak.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.empresa",idioma)).append(", ");
   		if(citacion.getMesa().equals("1"))
   		{
   			aldeak.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.mesa",idioma)).append(", ");
   		}
   		if(StringUtils.isNotEmpty(citacion.getNombreImpug()))
   		{
   			aldeak.append(citacion.getNombreImpug()).append(", ");
   		}
   		aldeak.append(citacion.getSiglasSindicatos());
		mapaPar.put("<<PIE>>", aldeak.toString());
		buffer= W83bUtilidadesRTF.sustituirCadenaCaracteresRtf(plantilla.getFichero(), mapaPar);
		

		HashMap mapa=(HashMap)contexto.get("w83bMapaCitaciones");
		mapa.put("bufferComunicacion", buffer);
		mapa.put("numRegistro", resul);
		contexto.set("w83bMapaCitaciones",mapa);
	
		
//        response.setContentType("application/msword");
//        response.setContentLength(buffer.toString().getBytes().length);
//        response.setHeader("Content-disposition","attachment;filename="+plantilla.getNombrePlantilla());
//        response.getOutputStream().write(buffer.toString().getBytes());
//        response.getOutputStream().close();
//        response.getOutputStream().flush();

		
		return mapping.findForward("ok");	
	}
	
		
}

